# Player: huggingface_DeepSeek-V3-0324_PayoffMaximizer_A (as Player A)
# Meta-Round: 5
# Experiment: PMxPM, Run: 1
# API: huggingface, Model: deepseek-ai/DeepSeek-V3-0324
# Based on textual strategy: huggingface_DeepSeek_V3_0324_PayoffMaximizer_A_MR5_strategy.txt
# LLM Suggested Fallback: C

def huggingface_DeepSeek_V3_0324_PayoffMaximizer_A_MR5(my_history: list, opp_history: list, opponent_program_code: str) -> str:
    if not opp_history:
        return "C"  # Initial move: Cooperate
    
    opponent_code_lower = opponent_program_code.lower()
    
    # Check for deterministic opponent strategies
    if "always cooperate" in opponent_code_lower or "return 'c'" in opponent_code_lower:
        return "D"  # Exploit always-cooperate
    if "always defect" in opponent_code_lower or "return 'd'" in opponent_code_lower:
        return "C"  # Minimize losses against always-defect
    
    # Probing defect in round 3
    if len(my_history) == 2:
        return "D"
    
    # If opponent retaliated after probing defect, revert to TFT
    if len(my_history) >= 3 and my_history[-1] == "D" and opp_history[-1] == "D":
        return opp_history[-1]
    
    # If opponent continued cooperating after probing defect, defect selectively in later rounds
    if len(my_history) >= 4 and my_history[-1] == "D" and opp_history[-1] == "C":
        if len(my_history) >= 7:  # Last 3 rounds
            return "D"
    
    # Late-game exploitation: defect in last 2 rounds if opponent hasn't punished
    if len(my_history) >= 8 and all(h == "C" for h in opp_history[-3:]):
        return "D"
    
    # Default to TFT if no other conditions met
    if opp_history:
        return opp_history[-1]
    
    return "C"  # Fallback (shouldn't reach here)